IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_ENT_FILIAL]')) 
	begin
		return;
	end
else
begin
CREATE TABLE [dbo].[EST_PROD_ENT_FILIAL](
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[VLR_IT_MD] [money] NOT NULL,
	[VLR_ICMS_IT_MD] [money] NOT NULL,
	[VLR_DESC_IT_MD] [money] NOT NULL,
	[PERC_ICMS_MD] [money] NOT NULL,
	[PERC_IVA_MD] [money] NOT NULL,
	[VLR_ICMS_SUBST_IT_MD] [money] NOT NULL,
	[VLR_CUSTO_IT_MD] [money] NOT NULL,
	[QT_IT] [money] NOT NULL,
	[QT_EST_ANT] [money] NOT NULL,
	[DESC_FINAN] [money] NOT NULL,
	[DESC_FINAN_MD] [money] NOT NULL,
	[QTDE_NF_ENT] [int] NULL,
 CONSTRAINT [PK_EST_PROD_ENT_FILIAL] PRIMARY KEY NONCLUSTERED 
(
	[CD_PROD] ASC,
	[CD_NF] ASC,
	[CD_FILIAL] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_VLR_IT_MD]  DEFAULT ((0)) FOR [VLR_IT_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_VLR_ICMS_IT_MD]  DEFAULT ((0)) FOR [VLR_ICMS_IT_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_VLR_DESC_IT_MD]  DEFAULT ((0)) FOR [VLR_DESC_IT_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_PERC_ICMS_MD]  DEFAULT ((0)) FOR [PERC_ICMS_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_PERC_IVA_MD]  DEFAULT ((0)) FOR [PERC_IVA_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_VLR_ICMS_SUBST_MD]  DEFAULT ((0)) FOR [VLR_ICMS_SUBST_IT_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_VLR_CUSTO_IT_MD]  DEFAULT ((0)) FOR [VLR_CUSTO_IT_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_QT_IT]  DEFAULT ((0)) FOR [QT_IT]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_QT_EST_ANT]  DEFAULT ((0)) FOR [QT_EST_ANT]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_DESC_FINAN]  DEFAULT ((0)) FOR [DESC_FINAN]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_DESC_FINAN_MD]  DEFAULT ((0)) FOR [DESC_FINAN_MD]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] ADD  CONSTRAINT [DF_EST_PROD_ENT_FILIAL_QTDE_NF_ENT]  DEFAULT ((0)) FOR [QTDE_NF_ENT]

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL]  WITH NOCHECK ADD  CONSTRAINT [FK_EST_PROD_ENT_FILIAL_EST_NF_ENT_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD])
REFERENCES [dbo].[EST_NF_ENT_IT] ([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[EST_PROD_ENT_FILIAL] CHECK CONSTRAINT [FK_EST_PROD_ENT_FILIAL_EST_NF_ENT_IT]
END


